#!/usr/bin/env bash
set -euo pipefail

source "$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)/helpers.sh"

section "WordPress smoke tests"

connect_endpoint="$BLOGGER_API_URL/wp/connect.php"
status_endpoint="$BLOGGER_API_URL/wp/status.php"
test_post_endpoint="$BLOGGER_API_URL/wp/test_post.php"

curl_capture POST "$connect_endpoint" -H 'Content-Type: application/json' -d '{}'
assert_status 400
assert_body_contains 'Missing required fields'
echo "wp/connect.php rejects incomplete payloads"

curl_capture GET "$status_endpoint"
assert_status 400
assert_body_contains 'Invalid ref'
echo "wp/status.php rejects requests without tenant_ref"

curl_capture POST "$test_post_endpoint" -H 'Content-Type: application/json' -d '{}'
assert_status 400
assert_body_contains 'Invalid tenant_ref'
echo "wp/test_post.php rejects non-tenant payloads"
