#!/usr/bin/env bash
set -euo pipefail

source "$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)/helpers.sh"

section "Webhook smoke tests"

endpoint="$BLOGGER_API_URL/webhooks/yoco.php"
body='{"id":"smoke","type":"checkout","payload":{"metadata":{}}}'

curl_capture POST "$endpoint" -H 'Content-Type: application/json' -d "$body"
assert_status 401
assert_body_contains 'Invalid signature'
echo "Missing signature headers are rejected"

curl_capture POST "$endpoint" \
  -H 'Content-Type: application/json' \
  -H 'Webhook-Signature: v1,invalid' \
  -H 'Webhook-Id: smoke-test' \
  -H 'Webhook-Timestamp: 1234567890' \
  -d "$body"

assert_status 401
assert_body_contains 'Invalid signature'
echo "Invalid signature headers are rejected"
