#!/usr/bin/env bash
set -euo pipefail

source "$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)/helpers.sh"

section "Download token smoke tests"

ref='t_0123456789abcdef'
endpoint="$BLOGGER_WEB_URL/download.php"

curl_capture GET "${endpoint}?ref=${ref}"
assert_status 400
assert_body_contains 'Missing ref or token'
echo "download.php rejects requests missing token"

curl_capture GET "${endpoint}?ref=${ref}&token=not_a_hex"
assert_status 400
assert_body_contains 'Invalid token format'
echo "download.php rejects poorly formatted tokens"
