#!/usr/bin/env bash
set -euo pipefail

source "$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)/helpers.sh"

section "Checkout smoke test"

endpoint="$BLOGGER_API_URL/checkout/create.php"
payload='{"email":"not-an-email","currency":"ZAR","amount_cents":9900}'

curl_capture POST "$endpoint" -H 'Content-Type: application/json' -d "$payload"
assert_status 400
assert_body_contains 'Valid email required'

echo "checkout/create.php rejects malformed email as expected"
