#!/usr/bin/env bash
set -euo pipefail

SCRIPT_DIR=$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)

echo "Running all smoke tests (set BLOGGER_API_URL / BLOGGER_WEB_URL to override)"

for script in smoke_checkout.sh smoke_webhooks.sh smoke_download.sh smoke_wp.sh; do
  echo
  echo ">>>> $script"
  bash "$SCRIPT_DIR/$script"
done

echo
echo "All smoke tests completed successfully."
