<?php
declare(strict_types=1);

header('Content-Type: application/json; charset=utf-8');

$cfg = require __DIR__ . '/../config.php';
require_once __DIR__ . '/SocialService.php';

function respond(int $code, array $payload): never {
  http_response_code($code);
  echo json_encode($payload, JSON_UNESCAPED_SLASHES);
  exit;
}

$service = new SocialService($cfg);
$ref = trim((string)($_GET['ref'] ?? ''));

if ($ref === '' || !preg_match('/^t_[a-f0-9]{16}$/', $ref)) {
  respond(400, ['ok' => false, 'error' => 'Invalid tenant_ref']);
}

$providers = $service->connectedProviders($ref);
$lastJob = $service->lastJob($ref);

respond(200, [
  'ok' => true,
  'providers' => $providers,
  'last_job' => $lastJob,
]);
