<?php
declare(strict_types=1);

require_once __DIR__ . '/SocialProviderInterface.php';

class LinkedInProvider implements SocialProviderInterface {
  public function getIdentifier(): string {
    return 'linkedin';
  }

  public function getDisplayName(): string {
    return 'LinkedIn';
  }

  public function preparePost(array $draft): array {
    return [
      'headline' => $draft['title'] ?? '',
      'text' => $draft['plaintext_excerpt'] ?? '',
    ];
  }

  public function post(array $credentials, array $content): array {
    // Stub: actual LinkedIn API integration to be implemented later.
    return ['ok' => true, 'message' => 'LinkedIn stub executed', 'content' => $content];
  }
}
