<?php
declare(strict_types=1);

require_once __DIR__ . '/SocialProviderInterface.php';

class FacebookProvider implements SocialProviderInterface {
  public function getIdentifier(): string {
    return 'facebook';
  }

  public function getDisplayName(): string {
    return 'Facebook';
  }

  public function preparePost(array $draft): array {
    return [
      'message' => $draft['plaintext_excerpt'] ?? '',
      'link_preview' => '',
    ];
  }

  public function post(array $credentials, array $content): array {
    // Stub: actual Facebook API integration to be implemented later.
    return ['ok' => true, 'message' => 'Facebook stub executed', 'content' => $content];
  }
}
