<?php
declare(strict_types=1);

/**
 * Config is env-driven. Do not store secrets in the repo.
 * See /.env.example for the expected environment variables.
 */

$appBase = (string)($_ENV['BLOGGER_WEB_BASE_URL'] ?? getenv('BLOGGER_WEB_BASE_URL') ?? 'https://blogger.mytown.ink');
$tenantsDir = (string)($_ENV['TENANT_STORAGE_PATH'] ?? getenv('TENANT_STORAGE_PATH') ?? '/home/mytown/blog.mytown.ink/tenants');

//
$previewTtl = (int)($_ENV['PREVIEW_TOKEN_TTL_SECS'] ?? getenv('PREVIEW_TOKEN_TTL_SECS') ?? 0);
if ($previewTtl <= 0) {
  $previewTtl = 604800;
}
$approveTtl = (int)($_ENV['APPROVE_TOKEN_TTL_SECS'] ?? getenv('APPROVE_TOKEN_TTL_SECS') ?? 0);
if ($approveTtl <= 0) {
  $approveTtl = 604800;
}

return [
  // Yoco
  'yoco_api_base'       => 'https://payments.yoco.com/api',
  'yoco_secret_key'     => (string)($_ENV['YOCO_SECRET_KEY'] ?? getenv('YOCO_SECRET_KEY') ?? ''),
  'yoco_webhook_secret' => (string)($_ENV['YOCO_WEBHOOK_SECRET'] ?? getenv('YOCO_WEBHOOK_SECRET') ?? ''),

  // App
  'app_base'    => $appBase,
  'tenants_dir' => rtrim($tenantsDir, '/'),

  // Kit + package locations (override with env if needed)
  'kit_zip_path'     => (string)($_ENV['KIT_ZIP_PATH'] ?? getenv('KIT_ZIP_PATH') ?? '/home/mytown/blog.mytown.ink/assets/blogger-kit.zip'),
  'app_package_path' => (string)($_ENV['APP_PACKAGE_PATH'] ?? getenv('APP_PACKAGE_PATH') ?? '/home/mytown/blog.mytown.ink/packages/blogger-app-v1.tar.gz'),

  // Optional logs (recommended: outside web root)
  'download_log' => (string)($_ENV['DOWNLOAD_LOG_PATH'] ?? getenv('DOWNLOAD_LOG_PATH') ?? ($tenantsDir . '/_download.log')),
  'webhook_log'  => (string)($_ENV['WEBHOOK_LOG_PATH'] ?? getenv('WEBHOOK_LOG_PATH') ?? ($tenantsDir . '/_yoco_webhook.log')),

  // Optional pricing default (create.php can use it if amount_cents omitted)
  'price_cents' => (int)($_ENV['PRICE_CENTS'] ?? getenv('PRICE_CENTS') ?? 9900),

  // WP credential encryption master key (base64 encoded 32 bytes)
  'wp_master_key_b64' => (string)($_ENV['WP_MASTER_KEY_B64'] ?? getenv('WP_MASTER_KEY_B64') ?? ''),

  // CORS
  'cors_allowed_origins' => [
    'https://blogger.mytown.ink',
    'null',
  ],
  'preview_token_ttl_secs' => $previewTtl,
  'approve_token_ttl_secs' => $approveTtl,
];
