<?php
declare(strict_types=1);

$PRICE_RANDS = 10000;
$PRICE_CENTS = $PRICE_RANDS * 100;
$API_BASE = 'https://api.blogger.mytown.ink';
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>MY.TOWN Blogger | Publish Consistently</title>
  <meta name="description" content="Generate and publish WordPress-ready posts in minutes." />
  <meta name="theme-color" content="#0b1220" />
  <style>
    body{margin:0;font-family:system-ui,-apple-system,Segoe UI,Roboto,Arial;background:#0b1220;color:#eaf0ff}
    .wrap{max-width:980px;margin:0 auto;padding:28px 18px}
    .card{background:#101a33;border:1px solid rgba(255,255,255,.08);border-radius:18px;padding:22px}
    h1{margin:0 0 10px;font-size:36px;line-height:1.1}
    p{color:#a8b3cf;line-height:1.5}
    .row{display:flex;gap:10px;margin-top:12px;flex-wrap:wrap}
    input{flex:1;min-width:240px;background:rgba(0,0,0,.25);border:1px solid rgba(255,255,255,.08);color:#eaf0ff;padding:12px;border-radius:12px;outline:none}
    button{border:0;background:#22c55e;color:#04130a;font-weight:900;padding:12px 14px;border-radius:12px;cursor:pointer;min-width:160px}
    button:disabled{opacity:.6;cursor:not-allowed}
    .status{margin-top:12px;font-size:13px}
    .badge{display:inline-block;margin-right:8px;padding:6px 10px;border:1px solid rgba(255,255,255,.08);border-radius:999px;color:#a8b3cf;font-size:12px;background:rgba(255,255,255,.03)}
  </style>
</head>
<body>
  <div class="wrap">
    <div class="card">
      <div>
        <span class="badge">MY.TOWN</span>
        <span class="badge">Blogger Engine</span>
        <span class="badge">Launch Special</span>
      </div>

      <h1>Publish consistently, without writing fatigue.</h1>
      <p>Pay once. Connect WordPress. Generate WordPress-ready posts in minutes.</p>
      <p><b>Launch special:</b> R<?= number_format($PRICE_RANDS) ?> once-off</p>

      <div class="row">
        <input id="email" type="email" placeholder="you@company.com" autocomplete="email" />
        <button id="buyBtn" onclick="buyNow()">Buy Now</button>
      </div>

      <div id="status" class="status"></div>
    </div>
  </div>

<script>
const API_URL = <?= json_encode($API_BASE . '/checkout/create.php') ?>;
const AMOUNT_CENTS = <?= (int)$PRICE_CENTS ?>;

function setStatus(msg, ok=true){
  const el = document.getElementById('status');
  el.textContent = msg || '';
  el.style.color = ok ? '#86efac' : '#fca5a5';
}

async function buyNow(){
  const email = document.getElementById('email').value.trim();
  if(!email){ setStatus("Please enter your email address.", false); return; }

  const btn = document.getElementById('buyBtn');
  btn.disabled = true;
  setStatus("Creating secure checkout...");

  try{
    const res = await fetch(API_URL, {
      method: "POST",
      headers: {"Content-Type":"application/json"},
      body: JSON.stringify({ email, amount_cents: AMOUNT_CENTS })
    });
    const j = await res.json().catch(()=> ({}));

    if(!res.ok || !j.ok || !j.redirectUrl){
      setStatus(j.error || "Checkout failed. Please try again.", false);
      btn.disabled = false;
      return;
    }

    setStatus("Redirecting to payment...");
    window.location.href = j.redirectUrl;
  }catch(e){
    setStatus("Network error. Please try again.", false);
    btn.disabled = false;
  }
}
</script>
</body>
</html>
