# OpenAI key guide (BYO key)

## Where to get an OpenAI API key
1. Visit `https://platform.openai.com/account/api-keys`.
2. Click _Create new secret key_ and copy it once (you won't be able to see it again).
3. Store it somewhere secure (password manager, encrypted notes, etc.).

## Saving the key on MY.TOWN
- Call `POST https://api.blogger.mytown.ink/openai/save.php` with JSON `{"ref":"t_...","api_key":"sk_..."}`.
- The API encrypts your key using the same master key that protects the WP credentials and stores the blob in `tenants/{ref}/data/openai.json`.
- You can overwrite a key by calling the same endpoint again.

## Testing the key
- Call `POST https://api.blogger.mytown.ink/openai/test.php` with `{"ref":"t_..."}`; the endpoint decrypts the key and makes a minimal OpenAI chat request to confirm it works.
- Success returns `{ "ok": true, "message": "ok" }`. Failure shows the OpenAI error (expired key, rate limit, etc.).

## Deleting or rotating the key
- Call `POST https://api.blogger.mytown.ink/openai/delete.php` with `{"ref":"t_..."}` to remove the stored key.
- After deleting, you must save a new key before `/content/generate.php` works again.

## How it will be used (Option 2)
- The key is stored **encrypted on the MY.TOWN server** and never sent to the customer device.
- The key is used to generate your content when you request a post (`POST /content/generate.php`).
- The preview + approve workflow keeps the customer in control of publication without exposing the key.

## Security tip
Treat your API key like a password. If it is leaked or rotated upstream, delete it via `/openai/delete.php` and save the new one.
