# 06. Security & compliance

## Secrets handling
- Do not ship secrets in downloadable zips.
- Do not commit tenant folders to git.
- Store WP app passwords encrypted server-side (already implemented).
- Store OpenAI keys encrypted with `WP_MASTER_KEY_B64` (AES-256-GCM) in `tenants/{ref}/data/openai.json`.

## Webhook verification (Yoco)
- `webhooks/yoco.php` expects Svix-style headers and computes an HMAC signature.
- Anti-replay window: 5 minutes (timestamp drift check).
- Webhook never trusts the event alone. It confirms status via `GET /checkouts/{id}` from Yoco API.

## Download token hardening
- Tokens are one-time and rotated after a successful download.
- Concurrency is guarded with `active.json.lock` and `flock`.

## WordPress SSRF defenses
`lib/wp_common.php` includes:
- URL validation (scheme must be http/https)
- Blocks localhost and private IP ranges (IPv4 and IPv6 unique local)
- Normalizes base URL

## Recommended production hardening
- Rate limit public endpoints (checkout creation, WP connect attempts)
- Audit logs for:
  - connect attempts
  - publish attempts
  - OpenAI generation requests
- Add per-tenant request quotas (anti-abuse)
- Add admin “kill switch” to disable tenant on fraud/chargeback
