# 08. Troubleshooting

## Not active yet on paid page
- Wait 10 to 30 seconds and refresh.
- Confirm webhook processed:
  - check `/home/mytown/blog.mytown.ink/tenants/_yoco_webhook.log`
  - confirm `tenants/{ref}/active.json` exists and `status=active`

## Invalid token when downloading kit
- Token is one-time.
- Refresh the paid page to fetch the new token, then download once.

## Package download failed (HTTP 403) during install
Likely causes:
- Wrong `.env` (mismatched `LICENSE_KEY` for that tenant)
- Tenant not active

Check:
- `tenants/{ref}/active.json` status
- `tenants/{ref}/.env` LICENSE_KEY
- API logs in `_kit_package.log`

## WordPress test post fails
- Confirm `WP_URL` is correct and reachable publicly
- Confirm WP Application Password is created for a user with post permissions
- Ensure REST API is not blocked by security plugins or WAF
- Check response body printed by scripts for exact WP error message

## Webhook signature fails
- Confirm `YOCO_WEBHOOK_SECRET` matches the secret configured on Yoco
- Confirm your server clock is correct (timestamp drift check)

## Kit missing on server
- Ensure `config.php['kit_zip_path']` exists and is readable

## Draft notification email
- **Template**
  - Subject: `MY.TOWN Blogger draft ready (ref {tenant_ref} / {draft_id})`
  - Body (plain text) includes:
    ```
    Hello,

    Tenant ref: {tenant_ref}
    Draft ID: {draft_id}

    Preview link:
    https://api.blogger.mytown.ink/content/preview.php?ref=...&draft=...&token=...

    Approve endpoint:
    https://api.blogger.mytown.ink/content/approve.php
    Approve token: {approve_token}

    Instructions:
    1. Review via the preview URL.
    2. POST the approve payload to publish (see sample curl in the email).

    Best,
    MY.TOWN Blogger
    ```
- **Troubleshooting**
  - If `/content/generate.php` returns `email_status: skipped_missing_smtp` or `failed`, verify `SMTP_HOST`, `SMTP_PORT`, `SMTP_USER`, `SMTP_PASS`, and `MAIL_FROM` match `.env.example`.
  - Check the PHP error log for `Draft email failed for ...` messages to see SMTP response errors.
  - `email_status: skipped_missing_email` means the tenant’s `active.json` lacks an `email` entry; confirm the webhook metadata includes the customer email.

## Secret Hygiene
- See the deployment runbook's [Secret Hygiene section](07_Deployment_Runbook.md#secret-hygiene) for what must stay out of the repo and how to run `bash scripts/secret_scan.sh`.
