# 10. Roadmap: Option 2 (production-ready)

## Goal
Server-side content generation with preview + approve publishing, reusing the proven content-bot flow pattern.

## Phase 1: BYO OpenAI key
- Add API endpoint to store OpenAI key encrypted per tenant
- Update paid dashboard and kit UX to ask for OpenAI key and “Test key”
- Store in `tenants/{ref}/data/openai.json`
- Never ship the key to the customer device

## Phase 2: Server-side post generation
- `POST /posts/generate.php`:
  - Validates tenant + license
  - Generates post payload (title, slug, html, meta)
  - Stores draft server-side
  - Returns preview + approve URLs

## Phase 3: Preview + approve
- `GET /posts/preview.php?token=...`:
  - Sanitizes HTML and renders preview page
- `POST /posts/approve.php?token=...`:
  - Creates post in WordPress via REST
  - Uses canonical `link` returned by WordPress
  - Emails “Published” confirmation

## Phase 4: Landing page, FAQs, support
- High converting landing page (benefits, proof, FAQs, pricing, CTA)
- Support button across web + kit
- Training docs + short install video
- Optional FAQ bot that answers only from docs

## Phase 5: Hardening
- Rate limits
- Abuse protection
- Admin kill switch
- Observability dashboard (basic)
