# 02. User flows

## Flow A: Purchase and provision
1. Customer enters email on landing page (`blogger_web/index.php`)
2. Web calls `POST https://api.blogger.mytown.ink/checkout/create.php`
3. API creates a Yoco checkout and provisions:
   - `tenants/{tenant_ref}/pending.json`
4. Customer pays on Yoco
5. Yoco webhook calls `POST https://api.blogger.mytown.ink/webhooks/yoco.php`
6. Webhook verifies signature and confirms checkout status via Yoco API
7. Webhook provisions tenant:
   - `tenants/{tenant_ref}/active.json` with status `active`
   - `tenants/{tenant_ref}/.env` including `LICENSE_KEY` and empty WP/OpenAI fields
   - download token in `active.json.download.token`

## Flow B: Download kit
1. Customer is redirected to `https://blogger.mytown.ink/paid/?ref={tenant_ref}`
2. Paid page reads `active.json` and exposes a “Download kit” button
3. Download hits `https://blogger.mytown.ink/download.php?ref=...&token=...`
4. Download endpoint:
   - validates ref + token
   - copies the server template kit zip
   - injects the tenant `.env` into the kit (root + `bootstrap_kit/.env`)
   - rotates token in `active.json` (one-time use)

## Flow C: Install kit (customer device)
1. Customer opens `START_HERE.html`
2. Customer runs:
   - Windows: `INSTALL-WINDOWS.cmd` (PowerShell installer)
   - Mac: `install.command`
   - Linux/Mac: `bash bootstrap_kit/install.sh`
3. Installer:
   - reads `.env` for `TENANT_REF` and `LICENSE_KEY`
   - calls `POST {API_BASE}/kit/package.php` to download a protected tarball
   - extracts into `bootstrap_kit/app/`
   - copies `.env` into the installed app folder

## Flow D: WordPress connect (current)
1. Customer fills `WP_URL`, `WP_USER`, `WP_APP_PASSWORD` in `.env`
2. Customer runs test script (placeholder):
   - `blogger-app/wp_test_post.php` (creates a draft post via WP REST)

## Flow E: Option 2 publish flow (server-driven)
```
POST /content/generate.php
            |
            v
   Draft stored (status: generated) + preview/approve tokens
            |
     GET /content/preview.php?ref=&draft=&token=...
            |
            v
   POST /content/approve.php (approve token)
            |
            v
WordPress REST publish → returns canonical `link`
```

1. Call `POST /content/generate.php` with `ref` and a `topic` or `prompt`; the API persists a draft under `tenants/{ref}/drafts/{draft_id}.json` and returns the preview/approve tokens along with the draft ID. Tokens expire after `PREVIEW_TOKEN_TTL_SECS`/`APPROVE_TOKEN_TTL_SECS` (default 7 days), so share the links promptly.
2. Email (or otherwise share) the preview URL (`/content/preview.php?ref=...&draft=...&token=...`); the GET request renders the stored HTML safely and exposes the plaintext + social snippets.
3. When the customer clicks approve, POST to `/content/approve.php` with the stored `ref`, `draft_id`, and the approve token. The endpoint decrypts the tenant's `data/wp.json` credentials, publishes via the WordPress REST API, and updates the draft state to `published` while recording `wp_post_id` and `wp_link`. Approve tokens are single-use/expiring, so invalid or expired tokens return `403`; if the draft is already `published` the endpoint simply returns the stored WordPress details and never publishes again.
4. Throughout the flow the draft `status` evolves through `generated`, `approved` (in-memory), `published`, or `failed`, keeping tokens single-purpose so only the intended preview/approve links work.
