# 05. Data storage

## Tenant directory
Configured in `blogger_api/config.php`:
- `tenants_dir` default: `/home/mytown/blog.mytown.ink/tenants`

Per tenant: `tenants/{tenant_ref}/`
- `.env` (license and placeholders)
- `pending.json` (checkout metadata)
- `active.json` (activation + rotating download token)
- `data/wp.json` (encrypted WP app password)
- (planned) `data/openai.json` (encrypted OpenAI key)
- (planned) `data/posts/*.json` (generated post payloads)

## active.json schema (current)
- `tenant_ref`
- `checkoutId`
- `email`
- `status`: `active`
- `activated_at`
- `download`:
  - `token`
  - `token_issued_at`
  - `last_token`
  - `last_used_at`
  - `last_used_ip`
  - `last_used_ua`

## wp.json schema (current)
- `wp_url`
- `wp_user`
- `app_pass_enc` (base64 ciphertext)
- `iv` (base64 IV)
- `connected_at`

## Server master key
Configured in `blogger_api/config.php`:
- `wp_master_key_file`: `blogger_api/.secrets/wp_master_key.b64`

This is a base64-encoded 32-byte key used to encrypt tenant secrets.
