# 03. Architecture

## High-level components
- **blogger_web**: public web UI, payment confirmation UI, downloadable kit packaging
- **blogger_api**: API layer for checkout, webhooks, tenant provisioning, WordPress connectivity
- **tenant store**: file-based storage under `/home/mytown/blog.mytown.ink/tenants`
- **kit assets**: template zip at `/home/mytown/blog.mytown.ink/assets/blogger-kit.zip`
- **app package**: tarball at `/home/mytown/blog.mytown.ink/packages/blogger-app-v1.tar.gz`
- **reference approval engine**: `blog_platform/content-bot` (SQLite-backed, preview+approve)

## Data storage (current)
Per tenant folder:
- `.env` (license, wp placeholders, openai placeholder)
- `pending.json` (created at checkout)
- `active.json` (activated by webhook, includes download token)
- `data/wp.json` (encrypted WP app password)

## Security model (current)
- Payment provisioning depends on Yoco webhook signature + Yoco API status confirmation.
- Downloads are protected by:
  - `active.json.download.token` (rotating one-time token)
  - server-side lock `active.json.lock`
- WP credentials are stored encrypted in `data/wp.json` using a server master key (`blogger_api/.secrets/wp_master_key.b64`).

## Code entry points
blogger_web:
- `/index.php` landing and “Buy Now”
- `/paid/index.php` confirmation page and download button
- `/download.php` one-time kit download

blogger_api:
- `/checkout/create.php` create checkout + provision tenant folder
- `/webhooks/yoco.php` validate webhook + activate tenant
- `/kit/package.php` serve protected tarball to installer
- `/wp/connect.php` save WP credentials (encrypted)
- `/wp/status.php` get connect state
- `/wp/test_post.php` create draft test post (connect verification)
- `/ping.php` health check
