# MY.TOWN Blogger (Blogger Kit) Documentation

Version: 2025-12-31  
Scope: `blogger_web` + `blogger_api` + kit assets + reference `content-bot` approval flow.

This documentation describes the current codebase and the planned production hardening work for **Option 2**:
> Generate content on the MY.TOWN server, allow the customer to preview and approve, then publish to WordPress via REST.  
> No WordPress admin login required to publish.

## What this product is
MY.TOWN Blogger is a productized “pay-once” kit that:
1. Takes payment via **Yoco Checkout**
2. Provisions a **tenant folder** (license + download token)
3. Lets the customer download an installer kit zip
4. The kit installs a small local app package
5. The customer connects their WordPress site using WP Application Passwords

## Primary domains
- Landing + paid flow: `https://blogger.mytown.ink`
- API: `https://api.blogger.mytown.ink`
- Server platform files (paths in config): `/home/mytown/blog.mytown.ink/...`

## Repos / modules (as currently structured in the zips)
- **blogger_web**: public landing page, paid confirmation page, kit download (`download.php`)
- **blogger_api**: checkout, webhook provisioning, WP connect/status/test, kit packaging endpoint
- **blog_platform/assets**: the downloadable kit template zip + installer scripts
- **blog_platform/packages**: the protected app package tarball served after install verification
- **blog_platform/content-bot**: reference implementation of preview + approve + publish flow (already working)

## Important current limitations (known)
- The customer is **not yet prompted** for their OpenAI key in the kit UX (but `OPENAI_API_KEY` exists in the tenant `.env` and is currently blanked during provisioning).
- The packaged “app” is currently a **placeholder** tarball (used to validate licensing + installer flow).
- WordPress “test post” creates a **draft** and returns a `link` and `preview_url`, but the overall workflow still needs the Option 2 approval publishing model.

## Production goals (Option 2)
- BYO OpenAI key capture + encrypted storage per tenant (server-side)
- Server-side generation that produces:
  - **Preview link** (tokenized, public, sanitized HTML)
  - **Approve link** (one click publish)
- Email delivery of preview + approve links
- High converting landing page + support button + FAQ/training

See `product/10_Roadmap_Option2.md`.
